<?php
/**
 * Plugin Name: CryptNote Secure Links
 * Description: Integrates CryptNote.pro with your WordPress installation to generate encrypted links and replace email body content with secure links.
 * Version: 1.0.0
 * Author: CryptNote
 * Author URI: https://cryptnote.pro
 * License: GPL-2.0-or-later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: cryptnote-secure-links
 * Domain Path: /languages
 */

if (!defined('ABSPATH')) {
    exit;
}

define('CRYPTNOTE_PRO_VERSION', '1.0.0');
define('CRYPTNOTE_PRO_PATH', plugin_dir_path(__FILE__));
define('CRYPTNOTE_PRO_URL', plugin_dir_url(__FILE__));

/**
 * Retorna os valores padrão das configurações.
 */
function cryptnote_pro_default_settings(): array
{
    return [
        'api_base' => 'https://cryptnote.pro/api/v1',
        'api_key' => '',
        'default_max_views' => 1,
        'default_expire_minutes' => '',
        'default_markdown' => 0,
        'default_format' => 'text',
        'email_enable' => 0,
        'email_template' => sprintf(
            "You received a protected message sent by %s via CryptNote.\nAccess the secure content: {share_url}\nThis link may expire after {max_views} view(s) or by the configured limit.",
            get_bloginfo('name')
        ),
        'email_send_html' => 1,
        'email_template_html' => sprintf(
            "<p>You received a protected message sent by %s via CryptNote.</p><p><a href=\"{share_url}\" target=\"_blank\" rel=\"noopener noreferrer\">Access secure content</a></p><p>This link may expire after {max_views} view(s) or by the configured limit.</p>",
            get_bloginfo('name')
        ),
    ];
}

/**
 * Recupera as configurações salvas mesclando com os valores padrão.
 */
function cryptnote_pro_get_settings(): array
{
    $saved = (array)get_option('cryptnote_pro_settings', []);
    $defaults = cryptnote_pro_default_settings();

    // Migração suave de versões antigas que só tinham default_markdown
    if (empty($saved['default_format'])) {
        $saved['default_format'] = !empty($saved['default_markdown']) ? 'markdown' : 'text';
    }

    return wp_parse_args($saved, $defaults);
}

require_once CRYPTNOTE_PRO_PATH . 'includes/class-cryptnote-admin.php';
require_once CRYPTNOTE_PRO_PATH . 'includes/class-cryptnote-client.php';
require_once CRYPTNOTE_PRO_PATH . 'includes/class-cryptnote-email.php';

/**
 * Inicializa os ganchos do plugin.
 */
function cryptnote_pro_bootstrap(): void
{
    if (is_admin()) {
        new CryptNote_Admin();
    }
    new CryptNote_Email();
}
add_action('plugins_loaded', 'cryptnote_pro_bootstrap');
