# WordPress Plugin - CryptNote Secure Links

WordPress plugin to integrate with **CryptNote.pro**, allowing you to generate encrypted links directly from the dashboard and replace email body content with a secure link that must be opened to view the content.

## Installation
- Copy the `plugin-wordpress` folder to `wp-content/plugins/` in your WordPress installation (or compress as `.zip` and upload via the plugins screen).
- In the plugins panel, activate **CryptNote Secure Links**.

## Configuration
Open *CryptNote* in the admin sidebar menu and adjust:
- **API Base Endpoint**: default is `https://cryptnote.pro/api/v1`. If using another domain/instance, change it here (the plugin calls `POST {api_base}/create.php`).
- **API Key**: if your API requires a key, it will be sent in the `X-API-Key` header.
- **Default Views**: link access limit (1–20) and default expiration in minutes (leave blank for no time expiration).
- **Content Format**: set messages as plain text, Markdown (`is_markdown=true`), or HTML (`is_html=true`).
- **Secure Emails**: when checked, all `wp_mail()` body content will be replaced with a CryptNote link. Attachments are removed to prevent data leakage.
- **Email Template**: body sent when emails are protected. Available placeholders: `{share_url}`, `{share_link}` (anchor tag), `{token}`, `{max_views}`, `{expire_minutes}`.

## Generate Links from Dashboard
On the same screen there's a **Generate encrypted link now** form:
- Enter the content, optional password, view limit, expiration, and content format.
- The plugin calls the creation API and displays the generated `share_url` and `token`.

## How Email Protection Works
- When "Enable secure links for all emails" is active, the `wp_mail` filter creates a CryptNote link with the original email body and replaces the message with text containing only the link.
- If the API fails, the email is sent with an error notice and **does not** include the original content.
- Attachments are discarded to ensure nothing sensitive is sent outside the link.

## API Payload
`POST {api_base}/create.php` with JSON:
```json
{
  "content": "message",
  "is_markdown": false,
  "is_html": false,
  "max_views": 1,
  "password": "optional",
  "expire_minutes": 60
}
```
Expected response: `{"success":true,"share_url":"...","token":"..."}`.

## Support
If you like CryptNote, consider supporting the project at [buymeacoffee.com/dolutech](https://buymeacoffee.com/dolutech).
